<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddFieldToDailyOffersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('mysql')->table('daily_offers', function($table) {
            $table->unsignedBigInteger('currencies_id')->nullable()->after('stores_id');
            $table->foreign('currencies_id')->references('currencies_id')->on('currencies')->cascadeOnUpdate()->nullOnDelete();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('mysql')->table('daily_offers', function($table) {
            $table->dropColumn('currencies_id');
        });
    }
}
